﻿using System;
using System.Collections.Generic;
using System.Text;
using IndianHealthService.BMXNet.WinForm.Configuration;
using IndianHealthService.BMXNet.WinForm;

namespace IndianHealthService.BMXNet.Tests
{
    public class TestUser
    {
        public static String ReadAppConfig(String parentName, String aName, String aDefaultValue)
        {
            String hit = System.Configuration.ConfigurationManager.AppSettings[parentName + "." + aName];

            return (hit == null || (hit.Length == 0)) ? aDefaultValue : hit;
        }

        public static bool ReadAppConfig(String parentName, String aName, bool defaultValue)
        {
            return "True".Equals(ReadAppConfig(parentName, aName,defaultValue.ToString()), StringComparison.InvariantCultureIgnoreCase);
        }

        public static int ReadAppConfig(String parentName, String aName, int anInt)
        {
            String hit = ReadAppConfig(parentName, aName, "");
            if (hit.Length == 0)
                return anInt;

            int result = -1;
            int.TryParse(hit, out result);
            return result;
        }

        public static TestUser ReadFromAppConfig(String aName)
        {
            TestUser user = new TestUser();
            RpmsConnectionSpec connection = new RpmsConnectionSpec();

            connection.Server = ReadAppConfig("Default", "rpmsHost", "");
            connection.Port = ReadAppConfig("Default", "bmxPort", 0);
            connection.NameSpace = ReadAppConfig("Default", "namespace", "");
            connection.UseWindowsAuthentication = ReadAppConfig("Default", "useWinAuth", false);

            connection.Server = ReadAppConfig(aName, "rpmsHost", connection.Server);
            connection.Port = ReadAppConfig(aName, "bmxPort", connection.Port);
            connection.NameSpace = ReadAppConfig(aName, "namespace", connection.NameSpace);
            connection.UseWindowsAuthentication = ReadAppConfig(aName, "useWinAuth", connection.UseWindowsAuthentication);

            user.ConnectionSpec = connection;
            user.AccessCode = ReadAppConfig(aName, "accessCode", ReadAppConfig("Default", "accessCode", ""));
            user.VerifyCode = ReadAppConfig(aName, "verifyCode", ReadAppConfig("Default", "verifyCode", ""));

            return user;
          }

        private String _name = null;

        public String Name
        {
            get { return _name; }
            set { _name = value; }
        }

        private RpmsConnectionSpec _connectionSpec = null;

        public RpmsConnectionSpec ConnectionSpec
        {
            get { return _connectionSpec; }
            set { _connectionSpec = value; }
        }
        private String _accessCode = null;

        public String AccessCode
        {
            get { return _accessCode; }
            set { _accessCode = value; }
        }
        private String _verifyCode = null;

        public String VerifyCode
        {
            get { return _verifyCode; }
            set { _verifyCode = value; }
        }

        public bool Login(LoginProcess aProcess)
        {
            return aProcess.AttemptAccessVerifyLogin(this.ConnectionSpec, this.AccessCode, this.VerifyCode);
        }
    }
}
